<?php
session_start();

//	Path to the file and file name
define('FILE_NAME', 'data/rotator_data.dat');

//	Go to login page if session doesn't exist
if (isset($_SESSION['logged_in']) == false || $_SESSION['logged_in'] !== true)
{
	header('Location: login.php');
	die();
}

//	Error stuff, should not happen but just in case
$error['status'] = false;
$error['message'] = '';

//	Check if form was submitted
if (isset($_POST['save']) && $_POST['save'] === 'true')
{
	//	Loop over each field in form and save it to file.
	//	Lines that are empty are removed.
	if (isset($_POST['url']) && count($_POST['url']) > 0)
	{
		$form_urls = array();
	
		foreach ($_POST['url'] as $url)
		{
			//	Ignore it if empty!
			if (mb_strlen(trim($url)) == 0)
			{
				continue;
			}
			else
			{		
				//	Else add the URL to array
				$form_urls[] = trim($url)."\n";
			}
		}
		
		//	Save the array to a file
		file_put_contents(FILE_NAME, $form_urls);
	}
}

//	Holds URL that we get from a file
$urls = array();

//	Load file and get URLs
if (file_exists(FILE_NAME))
{
	//	Try to open the file
	$handle = fopen(FILE_NAME, 'r');

	//	If file is opened, read it line by line and save data into array
	if ($handle) 
	{
		while (($buffer = fgets($handle, 4096)) !== false) 
		{
			$urls[] = $buffer;
		}
		
		//	Show error if there was a problem with the file
		if (feof($handle) == false) 
		{
			$error['status'] = true;
			$error['message'] = 'Problem reading a file!';
		}
		
		fclose($handle);
	}
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8" />
<title>Rotator Setup</title>
<link rel="stylesheet" href="css/style.css" type="text/css" />
</head>
 
<body>
	<div id="page">
		<h1>Rotator Setup</h1>
		<?php
		//	Show login error
		if ($error['status'] == true)
		{
		?>
		<p class="error"><?php echo $error['message']; ?></p>
		<?php
		}
		?>
		<form action="rotator.php" method="post" id="save-form">
			<div>
				<input type="hidden" name="save" value="true" />
			</div>
			<label class="form-field">
				<input type="text" name="url[0]" id="url_0" placeholder="Enter URL" value="<?php echo isset($urls[0]) ? htmlspecialchars($urls[0], ENT_QUOTES, 'UTF-8') : ''; ?>" />
			</label>
			<div id="field-container">
			<?php
			if (count($urls) > 1)
			{
				foreach ($urls as $key => $url)
				{
					if ($key > 0)
					{
					?>
					<label class="form-field">
						<input type="text" name="url[<?php echo $key; ?>]" id="url_<?php echo $key; ?>" placeholder="Enter URL" value="<?php echo htmlspecialchars($url, ENT_QUOTES, 'UTF-8'); ?>" />
						<span class="remove-url">x</span>
					</label>
					<?php
					}
				}
			}
			?>
			</div>
			<label for="submit" id="submit-btn">
				<a href="#" id="add-url">Add Another URL</a>
			</label>
			<label id="submit-btn">
				<input type="submit" name="submit" id="submit" value="Save Changes" />
			</label>
		</form>
	</div>
	<script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
	<script src="js/functions.js"></script>
	<script>
	var total_urls = <?php echo count($urls); ?>
	</script>
</body>
</html>