/*
 * Decompiled with CFR 0.152.
 */
package JUpload.http;

import JUpload.http.CaseInsensitiveHashMap;
import JUpload.utilities.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpResponse {
    private static final Logger logger = Logger.getLogger((class$JUpload$http$HttpResponse == null ? (class$JUpload$http$HttpResponse = HttpResponse.class$("JUpload.http.HttpResponse")) : class$JUpload$http$HttpResponse).getName());
    private String HTTP_STATUS_MESSAGE;
    private int HTTP_STATUS_CODE;
    private Map headerMap;
    private StringBuffer bodyBuffer;
    private int STATE = 1;
    private boolean closed;
    static /* synthetic */ Class class$JUpload$http$HttpResponse;

    public String getBody() {
        return this.bodyBuffer.toString();
    }

    public long getContentLength() {
        long size = 0L;
        try {
            size = Long.parseLong((String)this.headerMap.get("Content-Length"));
        }
        catch (NumberFormatException e) {
            return -1L;
        }
        return size;
    }

    public int getStatusCode() {
        return this.HTTP_STATUS_CODE;
    }

    public String getStatusMessage() {
        return this.HTTP_STATUS_MESSAGE;
    }

    public boolean isConnectionClosed() {
        String strConnStatus;
        if (this.headerMap != null && this.headerMap.containsKey("Connection") && (strConnStatus = (String)this.headerMap.get("Connection")).startsWith("close")) {
            return true;
        }
        return this.closed;
    }

    public boolean isSuccessful() {
        return this.HTTP_STATUS_CODE >= 200 && this.HTTP_STATUS_CODE < 300;
    }

    public void parse(InputStream pin) {
        if (this.isConnectionClosed()) {
            return;
        }
        logger.fine("Parsing HTTP Response in state " + this.STATE);
        if (this.STATE == 1) {
            logger.finest("Reading first state");
            this.headerMap = new CaseInsensitiveHashMap();
            this.bodyBuffer = new StringBuffer();
            String HTTP_HEADER_LINE = this.readLine(pin);
            logger.finest("HTTP_HEADER_LINE=" + HTTP_HEADER_LINE);
            if (HTTP_HEADER_LINE.equals("")) {
                logger.warning("Empty first line!");
                return;
            }
            ++this.STATE;
            StringTokenizer tok = new StringTokenizer(HTTP_HEADER_LINE);
            if (!tok.hasMoreTokens()) {
                logger.warning("No HTTP Version!");
                return;
            }
            tok.nextToken();
            if (!tok.hasMoreTokens()) {
                logger.warning("No Status Code!");
                return;
            }
            String strStatusCode = tok.nextToken().trim();
            this.HTTP_STATUS_MESSAGE = tok.nextToken("\r\n").trim();
            try {
                this.HTTP_STATUS_CODE = Integer.parseInt(strStatusCode);
            }
            catch (NumberFormatException e) {
                this.HTTP_STATUS_CODE = -1;
                e.printStackTrace();
            }
        }
        if (this.STATE == 2) {
            while (true) {
                String line = this.readLine(pin);
                logger.finest("Read line in second phase:" + line);
                if (line == null || line.equals("")) break;
                int pos = line.indexOf(58);
                if (pos <= 0) continue;
                String key = line.substring(0, pos).trim();
                String value = line.substring(pos + 2).trim();
                this.headerMap.put(key, value);
            }
            logger.finest("End of header area");
            this.STATE = this.HTTP_STATUS_CODE == 100 ? 1 : ++this.STATE;
        }
        if (this.STATE == 3) {
            logger.finest("Preparing to read body");
            this.readBody(pin);
            this.STATE = 1;
        }
    }

    private void readBody(InputStream in) {
        try {
            while (true) {
                if (this.isChunked()) {
                    logger.warning("Reading chunked body");
                    String chunk = this.readChunkedBody(in);
                    this.bodyBuffer.append(chunk);
                    break;
                }
                int avail = in.available();
                if (avail <= 0) {
                    logger.warning("No bytes available in body");
                    return;
                }
                logger.log(Level.FINEST, "Reading " + avail + " bytes");
                byte[] buffer = new byte[avail];
                int read = in.read(buffer, 0, avail);
                if (read == -1) {
                    this.closed = true;
                    return;
                }
                if (read <= 0) continue;
                String str = new String(buffer, 0, read);
                logger.log(Level.FINEST, "Body part:[" + str + "]");
                this.bodyBuffer.append(str);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String readChunkedBody(InputStream is) {
        String a_response = "";
        String line = "";
        try {
            int dataLength = -1;
            while (true) {
                if ((line = this.readLine(is)).equalsIgnoreCase("")) {
                    return a_response;
                }
                logger.log(Level.FINEST, " Chunksize: <<< [" + line + "]");
                dataLength = Utils.getSizeFromHex(line);
                logger.log(Level.FINEST, " Reading " + dataLength + " bytes");
                if (dataLength < 0) continue;
                if (dataLength == 0) break;
                byte[] buffer = new byte[dataLength];
                int amount = 0;
                int total = 0;
                int rest = dataLength;
                while (rest > 0) {
                    amount = is.read(buffer, 0, rest);
                    rest = dataLength - (total += amount);
                    String strChunk = new String(buffer, 0, amount);
                    logger.log(Level.FINEST, " Read " + amount + " bytes");
                    logger.log(Level.FINEST, " <<< [" + strChunk + "]");
                    a_response = a_response + strChunk;
                }
                this.readLine(is);
            }
            logger.log(Level.FINEST, "end of chunked response");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return a_response;
    }

    private boolean isChunked() {
        String mode;
        return this.headerMap.keySet().contains("transfer-encoding") && (mode = (String)this.headerMap.get("transfer-encoding")).toLowerCase().indexOf("chunked") >= 0;
    }

    public String readLine(InputStream in) {
        StringBuffer data = new StringBuffer();
        try {
            while (true) {
                int c;
                if ((c = in.read()) == -1) {
                    return data.toString();
                }
                if (c == 13) {
                    c = in.read();
                    if (c == 10) {
                        return data.toString();
                    }
                    data.append('\r');
                }
                data.append((char)c);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return data.toString();
        }
    }

    public String readLine(InputStream in, boolean strictMode) {
        if (strictMode) {
            return this.readLine(in);
        }
        StringBuffer data = new StringBuffer();
        try {
            int c;
            while ((c = in.read()) == 10 || c == 13) {
            }
            data.append((char)c);
            while (true) {
                if ((c = in.read()) == -1) {
                    return data.toString();
                }
                if (c == 13 || c == 10) {
                    return data.toString();
                }
                data.append((char)c);
            }
        }
        catch (IOException e) {
            return data.toString();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

