/*
 * Decompiled with CFR 0.152.
 */
package JUpload.swingVersion;

import JUpload.swingVersion.IQueueListener;
import JUpload.swingVersion.IQueueView;
import JUpload.swingVersion.JUpload;
import JUpload.swingVersion.myListCellRenderer;
import JUpload.utilities.Configurator;
import JUpload.utilities.Debug;
import JUpload.utilities.QueueSelectedFiles;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import netscape.javascript.JSObject;

public class JFileList
extends JList
implements ListSelectionListener,
KeyListener,
IQueueView,
IQueueListener {
    private static final long serialVersionUID = 3258688789055549491L;

    JFileList(QueueSelectedFiles queue) {
        super(queue.getListModel());
        if (Configurator.getRemoveBorders()) {
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        queue.addQueueListener(this);
        this.setSelectionMode(2);
        this.addListSelectionListener(this);
        this.addKeyListener(this);
        this.setVisibleRowCount(-1);
        this.setCellRenderer(new myListCellRenderer());
        if (Configurator.getAutoselectLastFile()) {
            queue.getListModel().addListDataListener(new AutoselectListener(this));
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        JUpload.getInstance().notifyFileSelectionListeners(e);
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            this.removeSelected();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    private void notifyJavascript() {
        JSObject win;
        if (JUpload.getInstance().applet.javascriptRemoveListenerRegistered && (win = JUpload.getInstance().applet.jsBrowserWindow) != null) {
            win.call(JUpload.getInstance().applet.javascriptRemoveListenerName, null);
        }
    }

    public Component getComponent() {
        return this;
    }

    public Object[] getSelected() {
        return this.getSelectedValues();
    }

    public void removeSelected() {
        DefaultListModel model = (DefaultListModel)this.getModel();
        try {
            while (this.getSelectedValue() != null) {
                Object obj = this.getSelectedValue();
                model.removeElement(obj);
                this.notifyJavascript();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        JUpload.getInstance().queueChanged(model);
        JUpload.getInstance().statpanel.updateModel(JUpload.getInstance().getQueueSelectedFiles().getListModel());
    }

    public void update() {
        this.validate();
        this.repaint(500L);
    }

    public void setSelected(Object object) {
        this.setSelectedValue(object, true);
    }

    public void queueChanged(DefaultListModel listModel) {
        this.revalidate();
    }

    public void queueChanging(DefaultListModel listModel) {
    }

    private class AutoselectListener
    implements ListDataListener {
        JFileList m_list;

        public AutoselectListener(JFileList t_list) {
            Debug.println(this, "AutoselectListener for " + t_list);
            this.m_list = t_list;
        }

        public void contentsChanged(ListDataEvent e) {
        }

        public void intervalAdded(ListDataEvent e) {
            SwingUtilities.invokeLater(new Runnable(this, e){
                private final /* synthetic */ ListDataEvent val$e;
                private final /* synthetic */ AutoselectListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    try {
                        this.this$1.m_list.setIgnoreRepaint(true);
                    }
                    catch (Error e1) {
                        // empty catch block
                    }
                    this.this$1.m_list.setSelectedIndex(this.val$e.getIndex1());
                    this.this$1.m_list.ensureIndexIsVisible(this.val$e.getIndex1());
                    try {
                        this.this$1.m_list.setIgnoreRepaint(false);
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            });
        }

        public void intervalRemoved(ListDataEvent e) {
        }
    }
}

