<?php
/*
Plugin Name: Trackback Feed
Plugin URI: http://indexingtool.com
Description: Creates an RSS feed of your trackbacks at http://yourdomain.com/trackbackfeed
Author: Trackback Feed
Version: 1.6.3
Author URI: http://indexingtool.com

Versions
---------
1.6.3	Displays most recent trackbacks first.
1.6.2	Excluded trackbacks in Trash.
1.6.1	Increased action priority to 9.
1.6		Excluded trackbacks marked as Spam.
1.5		Added code for wp_query status.
1.4		Updated code for lastBuildDate.
1.3		Added 500 item limit.
		Added description and content.
1.2		Added guid.
		Added HTTP 200 OK header status.
1.1		Added filters for title and url.
1.0		Initial version.
*/

class trackbackfeed {

	function trackbackfeed() {
		$this->version = '1.6.3';
		add_action('template_redirect', array(&$this, 'action'), 9);
	}// end function

	function action() {

		if ( is_404() ) {
	
			if ( false !== strpos($_SERVER['REQUEST_URI'], '/trackbackfeed') ) {

				global $wpdb, $wp_query;
				$wp_query->is_404 = false;
				$wp_query->is_feed = true;
				$lastcommentmodified = $wpdb->get_var("SELECT comment_date_gmt FROM $wpdb->comments ORDER BY comment_date_gmt DESC LIMIT 1");

				header('Status: 200 OK', true, 200);
				header('Content-Type: '.feed_content_type('rss-http').'; charset='.get_option('blog_charset'), true);
				echo '<?xml version="1.0" encoding="'.get_option('blog_charset').'"?'.">\n"
					.'<rss version="2.0"'."\n"
					.'xmlns:content="http://purl.org/rss/1.0/modules/content/"'."\n"
					.'xmlns:wfw="http://wellformedweb.org/CommentAPI/"'."\n"
					.'xmlns:dc="http://purl.org/dc/elements/1.1/"'."\n"
					.'xmlns:atom="http://www.w3.org/2005/Atom"'."\n"
					.'xmlns:sy="http://purl.org/rss/1.0/modules/syndication/"'."\n"
					.'xmlns:slash="http://purl.org/rss/1.0/modules/slash/">'."\n"
					.'<channel>'."\n"
					.'<title>Trackbacks for '.get_bloginfo('name').'</title>'."\n"
					.'<atom:link href="';
					self_link();
					echo '" rel="self" type="application/rss+xml" />'."\n"
					.'<link>';
					self_link();
					echo '</link>'."\n"
					.'<description>'.get_bloginfo('name').' Trackbacks v'.$this->version.'</description>'."\n"
					.'<lastBuildDate>'.mysql2date('D, d M Y H:i:s +0000', $lastcommentmodified, false).'</lastBuildDate>'."\n"
					.'<language>'.get_option('rss_language').'</language>'."\n";
					
				$trackbacks = $wpdb->get_results( $wpdb->prepare("SELECT comment_author, comment_author_url, comment_date_gmt, comment_content FROM $wpdb->comments WHERE comment_type IN ('pingback', 'trackback') AND comment_approved NOT IN ('spam', 'trash') ORDER BY comment_date_gmt DESC LIMIT 500") );
				foreach ( $trackbacks as $trackback ) {
					echo "<item>\n"
						."<title>".apply_filters('the_title_rss', $trackback->comment_author)."</title>\n"
						."<link>".esc_url($trackback->comment_author_url)."</link>\n"
						."<pubDate>".mysql2date('D, d M Y H:i:s +0000', $trackback->comment_date_gmt)."</pubDate>\n"
						."<guid>".esc_url($trackback->comment_author_url)."</guid>\n"
						."<description>".apply_filters('comment_text_rss', $trackback->comment_content)."</description>\n"
						."<content:encoded><![CDATA[".apply_filters('get_comment_text', $trackback->comment_content)."]]></content:encoded>"
						."</item>\n";
				}// end foreach
				echo "</channel>\n"
				."</rss>";
				exit();

			}// end if

		}// end if
	
	}// end function

}// end class
$trackbackfeed = new trackbackfeed;
