<?php
/*
* Captcha Services
*
* Web Traffic Genius Pro v3.5.4
* Copyright (c) 2010-2010
* Success on the Internet Pty Ltd
* PO Box 25
* Salisbury SA 5108
* Australia
* Phone: +61 422 512 549
* Fax: +61 8 8425 9657
* Web: http://www.webtrafficgenius.com
* Support: http://www.marketing-assassins.com
*
*/
require_once(dirname(__FILE__) . '/config.php');
require_once(dirname(__FILE__) . '/captcha_model.php');
require_once(dirname(__FILE__) . '/dbc_client.3.php');
require_once(dirname(__FILE__) . '/other_functions.php');

wtg_db_check_and_create();
wtg_messages();

function wtg_manage_captchas() {
	$cp = new WTG_Captcha();
	$cp->initDB();
	if (isset($_GET['mode'])) {
		check_admin_referer('manage_captcha');
		if ($_GET['mode'] == 'edit') {  //edit aggregator
			if (!empty($_GET['id'])) {
				wtg_edit_captcha($_GET['id']);
				return ;
			}
		} elseif ($_GET['mode'] == 'reverse') {  //reverse the status of (tgb) aggregator
			if (!empty($_GET['id'])) {
				$cp->reverse_statusDB($_GET['id']);
			}
		}
	}
	wtg_display_captcha_list();
}

function _wtg_update_captcha() {
	if (strlen(trim($_POST['name'])) == 0) {
		echo '<div class="error"><p>Please input the captcha service name.</p></div>';
		return ;
	}
	
	$cp = new WTG_Captcha();
	$cp->initDB();
	$captcha = $cp->get_captchaDB($_POST['id']);
	
	if(!$captcha->name) {
		echo '<div class="error"><p>Sorry! There is no such captcha service that exists.</p></div>';
		return ;
	}
	
	if (strcmp($captcha->name, $_POST['name']) != 0) {
		$_POST['name'] = $captcha->name;
	}
	$cp->set_captcha_paramsDB($_POST['id'], trim($_POST['name']), trim($_POST['user']), trim($_POST['password']), trim($_POST['key']));
	echo '<div class="updated fade"><p>Update Successfully.</p></div>';
	return true;
}

function wtg_edit_captcha($id) {
	if (isset($_POST['updateDetail'])) {
		_wtg_update_captcha();
	}
	
	if (isset($_POST['testLogin'])) {
		_wtg_update_captcha();
		
		$captchaID = $_POST['id'];
		$cp = new WTG_Captcha();
		$cp->initDB();
		$captcha = $cp->get_captchaDB($captchaID);

		if ($captcha->name == "bypasscaptcha.com")
		{
			$key = $_POST['key'];
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, "http://bypasscaptcha.com/ex_left.php");
			curl_setopt ($ch, CURLOPT_POST, 1);
			curl_setopt ($ch, CURLOPT_POSTFIELDS, "key=".$key);
			curl_setopt ($ch, CURLOPT_COOKIEJAR, "cookie.txt");
			curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
			$test = curl_exec ($ch);
			//$members = curl_exec ($ch);
			curl_close ($ch);
			
			//echo $test;
			$pos = strpos($test, 'Total');
			if($pos === false) {
				echo '<div class="error"><p>Invalid Key.</p></div>';
			}
			else
				echo '<div class="updated fade"><p>Valid Key.</p></div>';
		}
		else if ($captcha->name == "deathbycaptcha")
		{
			$username = $_POST['user'];
			$password = $_POST['password'];
			
			// Put your username & password here
			/*$client = new DeathByCaptcha_Client($username, $password);
			$client->is_verbose = true;
			echo "Your balance is {$client->balance} cents\n";*/
			echo '<div class="error"><p>Test login for this service unavailable as for now.</p></div>';
		}
		else if ($captcha->name == "decaptcher.com")
		{
			$username = $_POST['user'];
			$password = $_POST['password'];
			
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, "http://72.233.78.211"); // http://72.233.78.211 or http://poster.decaptcher.com/
			curl_setopt ($ch, CURLOPT_POST, 1);
			curl_setopt ($ch, CURLOPT_POSTFIELDS, "function=balance&username=".$username."&password=".$password);
			curl_setopt ($ch, CURLOPT_COOKIEJAR, "cookie.txt");
			curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
			$test = curl_exec ($ch);
			//$members = curl_exec ($ch);
			curl_close ($ch);
			
			if(empty($test)) {
				echo '<div class="error"><p>Invalid Login.</p></div>';
			}
			else
				echo '<div class="updated fade"><p>Valid Login.</p></div>';
		}
	}

	$cp = new WTG_Captcha();
	$cp->initDB();
	$captcha = $cp->get_captchaDB($id);
	?>
		<div class="wrap">
			<h2>Edit Captcha's Detail</h2>
			
			<p>Note that some services may not let you test your login until you load you captcha service account.</p>
			<form name="detailForm" action="" method="post">
				<input type="hidden" name="orderID" />
				<input type="hidden" name="id" value="<?php echo $id;?>;" />
				<table id="captcha_list" class="widefat">
					<tr>
						<td width="20%"><p><label>Services Name:</label></p></td>
						<td><input type="text" id="name" name="name" value="<?php echo $captcha->name; ?>" size="30" readonly/></td>
					</tr>
					<?php
						if (($captcha->name == 'deathbycaptcha') || ($captcha->name == 'decaptcher.com'))
						{
					?>
					<tr>
						<td width="20%"><p><label>User name:</label></p></td>
						<td><input type="text" id="user" name="user" value="<?php echo htmlspecialchars($captcha->user); ?>" size="30"/></td>
					</tr>
					<tr>
						<td><p><label>Password:</label></p></td>
						<td><input type="text" id="password" name="password" value="<?php echo htmlspecialchars($captcha->password); ?>" size="30"/></td>
					</tr>
					<?php
						}
						else
						{
					?>
					<tr>
						<td><p><label>Key:</label></p></td>
						<td><input type="text" id="key" name="key" value="<?php echo htmlspecialchars($captcha->key); ?>" size="30"/></td>
					</tr>
					<?php
						}
					?>
					<tr>
						<td colspan="2">
						<input type="submit" name="testLogin" value="Test Login &raquo;" />
						<input type="submit" name="updateDetail" value="Update Captcha &raquo;" />
						</td>
					</tr>
				</table>
				<input type="hidden" name="id" value="<?php echo $captcha->id; ?>" />
			</form>
		</div>
	<?php
}

function wtg_display_captcha_list() {
?>
	<div class="wrap">
		<h2>Manage Captcha Services</h2>
		<form id="captcha" action="" method="post">
			<table id="captcha_list" class="widefat">
				<thead>
					<tr>
						<th>Service Name</th>
						<th>Status</th>
						<th colspan="2">Action</th>
					</tr>
				</thead>
				<tbody>
					<?php
						$cp = new WTG_Captcha();
						$cp->initDB();

						//echo "<pre>";print_r($cp->get_all_captchasDB());echo"</pre>";
						$captcha_list = $cp->get_all_captchasDB();
						if (is_array($captcha_list) && !empty($captcha_list)) 
						{
							$class = '';
							foreach ($captcha_list as $captcha)
							{
								$class = ( $class == 'class="alternate"' ) ? '' : 'class="alternate"';
								?>
									<tr <?php echo $class; ?>>
										<td><?php echo htmlspecialchars($captcha->name); ?></td>
										<td><?php echo ($captcha->status == 'enabled')? 'Enabled':'Disabled'; ?></td>
										
										<td><?php echo ($captcha->status == 'enabled')? '<a href="'.wp_nonce_url("admin.php?page=manage_captcha&amp;mode=reverse&amp;id=".$captcha->id, 'manage_captcha').'">Disable</a>':'<a href="'.wp_nonce_url("admin.php?page=manage_captcha&amp;mode=reverse&amp;id=".$captcha->id, 'manage_captcha').'">Enable</a>'?></td>
										<td><a href="<?php echo wp_nonce_url("admin.php?page=manage_captcha&amp;mode=edit&amp;id=".$captcha->id, 'manage_captcha')?>">Edit Detail</a></td>
									</tr>
								<?php
							}
						}
						else {
							echo '<tr><td colspan="3" align="center"><strong>No entries found</strong></td></tr>';
						}
					?>
				</tbody>
			</table>
		</form>
	</div>
<?php
}
?>